<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Midtrans\Snap;
use Midtrans\Config;


class payment extends Controller
{
    public function createTransaction(Request $request)
    {
        // Setup midtrans
        Config::$serverKey = config('services.midtrans.server_key');
        Config::$isProduction = config('services.midtrans.is_production');
        Config::$isSanitized = true;
        Config::$is3ds = true;

        $params = [
            'transaction_details' => [
                'order_id' => 'ORD-' . time(),
                'gross_amount' => $request->total,
            ],
            'customer_details' => [
                'first_name' => $request->name ?? 'Customer',
                'email' => $request->email ?? 'noemail@example.com',
            ],
            'enabled_payments' => ['qris'],
        ];

        $snapToken = Snap::getSnapToken($params);

        return response()->json([
            'token' => $snapToken
        ]);
    }
}