document.addEventListener("DOMContentLoaded", function () {
    // ===============================
    // BASIC STATE
    // ===============================
    let isLoggedIn = localStorage.getItem("isLoggedIn") === "true";
    const checkoutBtn = document.querySelector(".btn.checkout");
    const accountMenu = document.getElementById("accountMenu");
    const storess = document.getElementById("storess");
    const mobileActionIcon = document.getElementById("mobileActionIcon");
    const desktopLogout = document.getElementById("desktopLogoutBox");
    const userPicture = localStorage.getItem("userPicture");
    const userName = localStorage.getItem("userName");

    // ===============================
    // UPDATE UI (Profile Picture + Logout Visibility)
    // ===============================
    // Show profile photo if logged in
    if (isLoggedIn && userPicture) {
        accountMenu.innerHTML = `
            <img src="${userPicture}" alt="${userName}" 
                 class="rounded-circle border border-2"
                 width="35" height="35" style="object-fit:cover;">
        `;

        mobileActionIcon.innerHTML = `<i class="ri-logout-box-r-line"></i>`;
    } else {
        accountMenu.innerHTML = `<i class="ri-user-line"></i>`;
        mobileActionIcon.innerHTML = `<i class="ri-star-line"></i>`;
        storess.innerHTML = `<i class="ri-store-2-line"></i>`;
    }

    if (isLoggedIn) {
        desktopLogout.classList.add("show-desktop");
    } else {
        desktopLogout.classList.remove("show-desktop");
    }

    // ===============================
    // CHECKOUT BUTTON → Require Login
    // ===============================
    const loginModal = new bootstrap.Modal(
        document.getElementById("loginModal")
    );

    if (checkoutBtn) {
        checkoutBtn.addEventListener("click", function (e) {
            if (!isLoggedIn) {
                e.preventDefault();
                loginModal.show();
            }
        });
    }

    // ===============================
    // FORM LOGIN MANUAL (Email/Password)
    // ===============================
    document
        .getElementById("loginForm")
        .addEventListener("submit", function (e) {
            e.preventDefault();

            localStorage.setItem("isLoggedIn", "true");

            bootstrap.Modal.getInstance(
                document.getElementById("loginModal")
            ).hide();
            window.location.href = "/";
        });

    // ===============================
    // GOOGLE LOGIN (Auth2)
    // ===============================
    window.onload = function () {
        google.accounts.id.initialize({
            client_id:
                "571487130354-pskpr255fc73e097og2qff4htvb6qthl.apps.googleusercontent.com",
            callback: handleCredentialResponse,
        });

        google.accounts.id.renderButton(
            document.getElementById("g_id_signin"),
            {
                theme: "outline",
                size: "large",
                text: "signin_with",
                shape: "rectangular",
            }
        );
    };

    // Handle Google credential response
    async function handleCredentialResponse(response) {
        const data = parseJwt(response.credential);

        // save session
        localStorage.setItem("isLoggedIn", "true");
        localStorage.setItem("userName", data.name);
        localStorage.setItem("userEmail", data.email);
        localStorage.setItem("userPicture", data.picture);

        bootstrap.Modal.getInstance(
            document.getElementById("loginModal")
        ).hide();

        try {
            const res = await fetch("/google-login", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document
                        .querySelector('meta[name="csrf-token"]')
                        .getAttribute("content"),
                },
                body: JSON.stringify({
                    name: data.name,
                    email: data.email,
                    picture: data.picture,
                }),
            });

            const result = await res.json();

            if (result.status === "success") {
                Swal.fire({
                    title: "BERHASIL!",
                    text: result.message,
                    icon: "success",
                    timer: 1500,
                    showConfirmButton: false,
                });

                setTimeout(() => {
                    window.location.href = "/";
                }, 1500);
            } else {
                Swal.fire("BERHASIL!", result.message, "success");
            }
        } catch (err) {
            Swal.fire("GAGAL!", err, "error");
        }
    }

    // ===============================
    // LOGOUT FUNCTION (GLOBAL)
    // ===============================
    function logoutGoogle() {
        // Clear local session
        localStorage.removeItem("isLoggedIn");
        localStorage.removeItem("userName");
        localStorage.removeItem("userEmail");
        localStorage.removeItem("userPicture");

        // Google revoke
        if (google && google.accounts && google.accounts.id) {
            google.accounts.id.disableAutoSelect();
        }

        Swal.fire({
            title: "Logout Berhasil",
            icon: "success",
            timer: 1200,
            showConfirmButton: false,
        });

        setTimeout(() => {
            window.location.href = "/";
        }, 1200);
    }

    // Make logout available globally
    window.logoutGoogle = logoutGoogle;

    // ===============================
    // JWT PARSER
    // ===============================
    function parseJwt(token) {
        let base64Url = token.split(".")[1];
        let base64 = base64Url.replace(/-/g, "+").replace(/_/g, "/");

        let jsonPayload = decodeURIComponent(
            atob(base64)
                .split("")
                .map(
                    (c) => "%" + ("00" + c.charCodeAt(0).toString(16)).slice(-2)
                )
                .join("")
        );

        return JSON.parse(jsonPayload);
    }
});
