<div class="offcanvas offcanvas-end cart-offcanvas" tabindex="-1" id="cartOffcanvas">
    <div class="offcanvas-header">
        <h3 class="offcanvas-title">
            Keranjang Saya
        </h3>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas">
            <i class="ri-close-line"></i>
        </button>
    </div>
    <div class="offcanvas-body">
        <div class="cart-media">
            <ul class="cart-product">
                <!-- Isi keranjang akan di-render di sini oleh JavaScript -->
            </ul>

            <ul class="cart_total">
                <li>
                    <div class="total">
                        <h5>Sub Total : <span></span></h5>
                    </div>
                </li>
                <li>
                    <div class="buttons">
                        <a href="{{ url('Pesanan') }}" class="btn checkout">Buat Pesanan</a>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const CART_KEY = "cartData";
        let cart = JSON.parse(localStorage.getItem(CART_KEY)) || [];

        const cartQtyEl = document.querySelector(".cart_qty_cls");
        const cartList = document.querySelector(".cart-product");
        const subtotalEl = document.querySelector(".cart_total span");

        const saveCart = () => localStorage.setItem(CART_KEY, JSON.stringify(cart));

        const updateCartUI = () => {

            // Render isi cart
            cartList.innerHTML = "";
            let subtotal = 0;

            cart.forEach((item, index) => {
                subtotal += item.harga * item.qty;

                const li = document.createElement("li");
                li.innerHTML = `
                <div class="media">
                    <a href="#!">
                        <img src="${item.gambar}" class="img-fluid" alt="${item.nama}" 
                             style="width:70px;height:70px;object-fit:cover;border-radius:8px;">
                    </a>
                    <div class="media-body">
                        <h4>${item.nama}</h4>
                        <h4 class="quantity"><span>${item.qty} x Rp ${item.harga.toLocaleString("id-ID")}</span></h4>

                        <div class="qty-box">
                            <div class="input-group qty-container">
                                <button class="btn qty-btn-minus" data-index="${index}">
                                    <i class="ri-subtract-line"></i>
                                </button>

                                <input type="number" readonly value="${item.qty}" class="form-control input-qty">

                                <button class="btn qty-btn-plus" data-index="${index}">
                                    <i class="ri-add-line"></i>
                                </button>
                            </div>
                        </div>

                        <div class="close-circle">
                            <button class="close_button delete-button" data-index="${index}">
                                <i class="ri-delete-bin-line"></i>
                            </button>
                        </div>
                    </div>
                </div>`;
                cartList.appendChild(li);
            });

            // Update subtotal
            subtotalEl.textContent = `Rp ${subtotal.toLocaleString("id-ID")}`;

            // Update badge jumlah item
            const totalQty = cart.reduce((a, b) => a + b.qty, 0);
            cartQtyEl.textContent = totalQty;

            cartQtyEl.classList.add("bump");
            setTimeout(() => cartQtyEl.classList.remove("bump"), 300);

            // Simpan
            saveCart();

            // 🔥 Trigger event ke seluruh halaman
            window.dispatchEvent(new Event("cart-updated"));
        };

        // Render awal
        updateCartUI();

        /* =====================================================
            ADD TO CART BUTTON
        ===================================================== */
        document.querySelectorAll(".add-to-cart-btn").forEach(btn => {
            btn.addEventListener("click", () => {
                const id = btn.dataset.id;
                const nama = btn.dataset.nama;
                const harga = parseInt(btn.dataset.harga);
                const gambar = btn.dataset.gambar;

                const existing = cart.find(i => i.id == id);
                if (existing) {
                    existing.qty++;
                } else {
                    cart.push({
                        id,
                        nama,
                        harga,
                        gambar,
                        qty: 1
                    });
                }

                updateCartUI();
            });
        });

        /* =====================================================
            QTY + / - DAN DELETE
        ===================================================== */
        cartList.addEventListener("click", e => {
            const index = e.target.closest("button")?.dataset.index;
            if (index === undefined) return;

            if (e.target.closest(".qty-btn-plus"))
                cart[index].qty++;

            if (e.target.closest(".qty-btn-minus") && cart[index].qty > 1)
                cart[index].qty--;

            if (e.target.closest(".delete-button"))
                cart.splice(index, 1);

            updateCartUI();
        });

        /* =====================================================
            CLEAR CART
        ===================================================== */
        document.querySelector(".sidebar-title a")?.addEventListener("click", e => {
            e.preventDefault();
            if (confirm("Hapus semua isi keranjang?")) {
                cart = [];
                updateCartUI();
            }
        });
    });
</script>
