<?php $__env->startSection('content'); ?>
    <div class="payment-page py-5">

        <div class="container">
            <h3 class="fw-bold text-center mb-5 text-primary">Pembayaran Pesanan</h3>

            <div class="row g-4">

                
                <div class="col-lg-4">
                    <div class="card p-4 shadow-sm rounded-4 border-0">

                        <h5 class="fw-bold mb-3">Ringkasan Pesanan</h5>
                        <hr>

                        <ul class="list-group list-group-flush mb-3" id="orderSummary"></ul>

                        <div class="d-flex justify-content-between align-items-center mt-3 p-2 bg-light rounded-3">
                            <span class="fw-bold">Total</span>
                            <span id="totalAmount" class="fw-bold text-primary fs-5">Rp 0</span>
                        </div>

                    </div>
                </div>

                
                <div class="col-lg-8">
                    <div class="card p-4 shadow-sm rounded-4 border-0">

                        <h5 class="fw-bold mb-3">Pilih Metode Pembayaran</h5>

                        
                        <div class="payment-methods">

                            <label class="payment-option mb-3">
                                <input type="radio" name="payment_type" value="qr" class="form-check-input me-2"
                                    checked>
                                <span class="fw-semibold">Bayar via QRIS</span>
                            </label>

                            <label class="payment-option mb-3">
                                <input type="radio" name="payment_type" value="cashier" class="form-check-input me-2">
                                <span class="fw-semibold">Bayar di Kasir</span>
                            </label>

                        </div>

                        <hr class="my-4">

                        
                        <div id="qrPaymentBox" class="payment-box">
                            <h6 class="fw-bold mb-3">Scan QR untuk Membayar</h6>

                            <div class="text-center">
                                <img src="<?php echo e(asset('assets/Qrisdiza.jpeg')); ?>" width="220" class="rounded mb-3 shadow"
                                    alt="QRIS">
                                <p class="text-muted small">Gunakan aplikasi e-wallet / mobile banking untuk membayar.</p>
                            </div>

                            <button id="payNow" class="btn btn-primary w-100 py-3 mt-3">
                                Bayar Sekarang (QRIS)
                            </button>
                        </div>

                        
                        <div id="cashierPaymentBox" class="payment-box d-none">
                            <h6 class="fw-bold mb-2">Bayar di Kasir</h6>
                            <p class="text-muted small mb-2">Tunjukkan kode berikut ke petugas kasir:</p>

                            <div class="bg-light rounded p-3 text-center fs-4 fw-bold shadow-sm" id="paymentCode">
                                #ORDXXXX
                            </div>

                            <button class="btn btn-success w-100 py-3 mt-3 fw-semibold">
                                Selesaikan Pesanan di Kasir
                            </button>
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>

    
    <style>
        .payment-option {
            padding: 14px 18px;
            border: 1px solid #ddd;
            border-radius: 12px;
            display: flex;
            align-items: center;
            cursor: pointer;
            background: #fafafa;
            transition: .2s;
        }

        .payment-option:hover {
            background: #eef4ff;
            border-color: #bcd2ff;
        }

        .payment-box {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 12px;
            border: 1px solid #eee;
        }

        .list-group-item {
            background: transparent !important;
            border: 0 !important;
            padding: 12px 0;
            border-bottom: 1px solid #eaeaea !important;
        }
    </style>

    <script src="https://app.sandbox.midtrans.com/snap/snap.js"
        data-client-key="<?php echo e(config('services.midtrans.client_key')); ?>"></script>


    <script>
        /* ============================
                SWITCH PAYMENT METHOD
            ============================ */
        document.querySelectorAll('input[name="payment_type"]').forEach(radio => {
            radio.addEventListener("change", function() {
                document.getElementById("qrPaymentBox").classList.toggle("d-none", this.value !== "qr");
                document.getElementById("cashierPaymentBox").classList.toggle("d-none", this.value !==
                    "cashier");
            });
        });

        /* ============================
            ELEMENT TARGET
        ============================ */
        const orderSummary = document.getElementById("orderSummary");
        const totalAmount = document.getElementById("totalAmount");

        /* ============================
            RENDER ORDER SUMMARY
        ============================ */
        function renderOrderSummary() {

            let cart = [];

            try {
                cart = JSON.parse(localStorage.getItem("cartData") || "[]");
            } catch (e) {
                console.error("Cart parse error:", e);
            }

            orderSummary.innerHTML = "";
            let total = 0;

            cart.forEach(item => {

                const li = document.createElement("li");
                li.classList.add("list-group-item");

                li.innerHTML = `
                <div class="d-flex align-items-center gap-3">
                    <img src="${item.gambar}" 
                        class="rounded"
                        width="55" height="55"
                        style="object-fit:cover">

                    <div class="flex-fill">
                        <span class="fw-bold">${item.nama}</span><br>
                        <span class="text-muted small">Qty: ${item.qty}</span>
                    </div>

                    <div class="text-end fw-semibold">
                        Rp ${(item.harga * item.qty).toLocaleString('id-ID')}
                    </div>
                </div>
            `;

                orderSummary.appendChild(li);
                total += item.harga * item.qty;
            });

            totalAmount.innerText = "Rp " + total.toLocaleString("id-ID");

            // simpan total untuk midtrans
            window.totalBayar = total;
        }

        /* ============================================================
            UPDATE REALTIME SAAT CART DI OFFCANVAS DIUBAH
        ============================================================ */

        // jika cart berubah di tab lain
        window.addEventListener("storage", function(event) {
            if (event.key === "cartData") renderOrderSummary();
        });

        // jika cart diubah di halaman yg sama (offcanvas)
        window.addEventListener("cart-updated", renderOrderSummary);

        // jika user kembali ke halaman ini
        window.addEventListener("pageshow", renderOrderSummary);

        // tab kembali aktif
        document.addEventListener("visibilitychange", () => {
            if (!document.hidden) renderOrderSummary();
        });

        // initial load
        renderOrderSummary();

        /* ============================
            ORDER CODE
        ============================ */
        document.getElementById("paymentCode").innerText = "ORD-" + Date.now();

        /* ============================
            MIDTRANS QRIS PAYMENT
        ============================ */
        document.getElementById("payNow").addEventListener("click", function() {

            fetch("<?php echo e(url('midtrans/pay')); ?>", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                    },
                    body: JSON.stringify({
                        total: window.totalBayar,
                        name: localStorage.getItem("userName"),
                        email: localStorage.getItem("userEmail")
                    })
                })
                .then(res => res.json())
                .then(data => {
                    console.log(data);
                    snap.pay(data.token, {
                        onSuccess: () => window.location.href = "/payment/success",
                        onPending: () => window.location.href = "/payment/pending",
                        onError: () => alert("Pembayaran gagal")
                    });
                });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Customer.Layout.Index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mymac/Documents/PROJECT/Disebelah/disebelah/resources/views/Customer/Page/Pesanan.blade.php ENDPATH**/ ?>